<?php get_header();?>

<?php
if (have_posts()) :
?>	

	<?php
	// Get the current term object
	$term = get_queried_object();

	// Imagem de fundo do page title
	if (get_field('page_title_img', $term)) {
		$pageTitleBg = get_field('page_title_img', $term);
	} else {
		$pageTitleBg = get_template_directory_uri() .'/images/bg/header-acao-pelo-clima.jpg';
	}

	// Icone
	if (get_field('page_title_icon', $term)) {
		$pageTitleIcon = get_field('page_title_icon', $term);
	} else {
		$pageTitleIcon = get_template_directory_uri() .'/images/icones/headers/icone-acao-pelo-clima.svg';
	}

	// Titulo	
	if (get_field('page_title_tit', $term)) {
		$pageTitle = get_field('page_title_tit', $term);
	} else {
		$pageTitle = get_the_archive_title();
	}

	// Descricao
	if (get_field('page_title_desc', $term)) {
		$pageTitleDesc = get_field('page_title_desc', $term);
	} else {
		$pageTitleDesc = '';
	}
	?>

	<div class="page-title-wrapper indicadores" style="background-image:url(<?php echo $pageTitleBg; ?>);">
		<div class="page-title">
			<div class="icone">
				<img src="<?php echo $pageTitleIcon; ?>" alt="Icone" title="Icone" />
			</div>
			<div class="conteudo">
				<h1 class="p-title"><?php echo $pageTitle; ?></h1>
				<div class="p-desc"><?php echo $pageTitleDesc; ?></div>
			</div>
		</div>
	</div>
	<!-- end .page-title-wrapper -->

	<div class="breadcrumbs">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<span>Home</span>
					<span><?php echo $pageTitle; ?></span>
					<span><?php echo get_the_title();?></span>
				</div>
			</div>
		</div>
	</div>
	<!-- end .breadcrumbs -->


	<div class="content-wrapper single-indicador">

	<!-- teste -->
	<div id="div1" style="background: #fff; border: 4px solid blue; padding: 20px;">
		Resultados...1
	</div>

	<div id="div2" style="background: #fff; border: 4px solid red; padding: 20px; margin-top: 30px;">
		Resultados...2
	</div>
	<!-- end teste -->

		<div class="container">

			<div class="post__meta">
				<div class="row">
					<div class="col-md-6">
						<div class="column col-esq">
							<div class="titulo-ungc">
								UNGC 
								<?php
								$terms = get_the_terms( $post->ID , 'ungc' );
								foreach ( $terms as $term ) {
									echo $term->name . '&nbsp;';
								}
								?>
							</div>
							<div class="numeros">
								<div class="numero">7
									<div class="hidden-content">
										<strong>PRINCÍPIO 7</strong>
										As empresas devem apoiar uma abordagem preventiva aos desafios ambientais
									</div>
								</div>
								<div class="numero">8
									<div class="hidden-content">
										<strong>PRINCÍPIO 8</strong>
										Desenvolver iniciativas para promover maior responsabilidade ambiental
									</div>
								</div>
								<div class="numero">9
									<div class="hidden-content">
										<strong>PRINCÍPIO 9</strong>
										Incentivar o desenvolvimento e difusão de tecnologias ambientalmente amigáveis
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="col-md-6">
						<div class="column col-dir">
							<div class="ods-list">
								<?php
								$terms = get_the_terms( $post->ID , 'ods' );
								foreach ( $terms as $term ) {
									echo "<img src='" . get_template_directory_uri() . "/images/ods/" . $term->name . ".svg' />";
								}
								?>
							</div>
						</div>
					</div>
					
				</div>
			</div>
			<!-- end .post__meta -->
			
		</div>
		<!-- end .container -->

		<div class="container container2">

			<div class="col-left">
				<?php require_once('inc/menu-lateral.php'); ?>
			</div>
			<!-- end .col-left -->

			<div class="col-right">
				<article class="article-item" id="<?php echo get_the_id();?>">

				<?php
				if (have_posts()) :
					while (have_posts()):
						the_post();
						global $post;
						?>
						
						<header class="post-header">
							<h1><?php echo get_the_title();?></h1>
						</header>
						


						<div class="post__content">
							<?php the_content(); ?>
						</div>
						<!-- end .post__content -->

						<?php
						endwhile;
					endif;
					?>

				</article>
				<!-- end article -->

			</div>
			<!-- end .col-right -->	

		</div>
		<!-- .custom-container -->

	</div>
	<!-- .content-wrapper -->
		
	<?php
	//wp_reset_postdata();
	?>

<?php
endif;
?>

<?php get_footer(); ?>